//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
#pragma once


// Dokument CAssemblyDoc
interface IMetaDataImport;
interface IMetaDataDispenserEx;

class CAssemblyDoc : public CDocument
{
	DECLARE_DYNCREATE(CAssemblyDoc)

public:
	CAssemblyDoc();
	virtual ~CAssemblyDoc();
	virtual void Serialize(CArchive& ar);   // zastpienie dla dokumentu i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	IMetaDataImport* MetaDataImportInterface()
	{
		if(m_pImport != NULL)
		{
			m_pImport->AddRef();
			return m_pImport;
		}
		else
			return NULL;
	}
	IMetaDataDispenserEx* MetaDataDispenserInterface()
	{
		if(m_pDisp != NULL)
		{
			m_pDisp->AddRef();
			return m_pDisp;
		}
		else
			return NULL;
	}
protected:

	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);

private:
	CString m_sAssemblyPath;
	IMetaDataImport *m_pImport;
	IMetaDataDispenserEx *m_pDisp;
};
